<?php

use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\CustomerController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PackageController;


Route::get('/', function () {
    return view('shop.home.index');
});


// // package
// Route::get('packages', [PackageController::class, 'index']);
// package
Route::get('packages', [PackageController::class, 'index'])->name('package.index');
Route::post('packages', [PackageController::class, 'store'])->name('package.store');

// authentications
Route::get('registration', [CustomerController::class, 'register'])->name( 'customer.register');
Route::post('registration', [CustomerController::class, 'create'])->name('customer.register.validate');
Route::get('login', [CustomerController::class, 'index'])->name('customer.login');
Route::post('login', [CustomerController::class, 'checkValidate'])->name('customer.login.check');

// customer protected
Route::group(['middleware' => 'auth:customer'], function () {
    Route::get('logout', [CustomerController::class, 'logout'])->name('customer.logout');
});

// checkout
Route::get('checkout', [CheckoutController::class, 'index'])->name('checkout.index');



