<?php

use Illuminate\Foundation\Application;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

//All controllers
use App\Http\Controllers\Admin\CatalogCategoryController;
use App\Http\Controllers\Admin\CatalogProductController;

Route::get('/', function () {
    return Inertia::render('Auth/Login', [
        'canLogin' => Route::has('login'),
        'canRegister' => Route::has('register'),
    ]);
});

Route::middleware(['auth:sanctum', 'verified'])->group(function () {
    Route::get('/dashboard', function () {
        return Inertia::render('Dashboard');
    })->name('dashboard');


    Route::prefix('catalog/')->name('catalog.')->group(function () {
        // Catalog
        Route::resource('category', CatalogCategoryController::class);
        // Product
        Route::resource('product', CatalogProductController::class);
    });
});


