
@extends('shop.layouts.app')

@section('content')
    <x-page-banner title="Select Packages" subTitle="Prepared, Packed & Delivered the same day"/>

    <section class="section-padding" id="app">
        <div class="container">

            <form class="row" action="" method="POST">
                @csrf
                <div class="col-md-4">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <h1 class="text-left">Choose Your Package</h1>
                        </div>

                            <div class="col-md-12 pl-8 pr-8" v-for="(package, pc) in packages" :key="pc">
                                <div class="packagesbox">
                                    <div class="boxcontent text-center">@{{ package.name }}</div>
                                    <div class="row package-price-container">
                                            <div class="no-padding package-price-item" :class="'col-md-'+12/package.package_price.length"
                                                v-for="(price, pr) in package.package_price" :key="pr">
                                                <div class="choosedates">
                                                    <div class="form-check text-center">
                                                        <input
                                                            class="form-check-input package-days"
                                                            type="radio"
                                                            :data-day="price.days"
                                                            :data-range="package.days_range"
                                                            :data-price="price.price"
                                                           :checked="selected.package_id == price.id"
                                                            {{-- :value="price.id" --}}
                                                            name="package"
                                                            @change="packageChanged(price, package.days_range)"
                                                            {{-- @if($package_key == 0 ) checked @endif --}}
                                                            :id="package.id+'_'+price.id"
                                                        >
                                                        <label class="form-check-label" :for="package.id+'_'+price.id">
                                                           @{{  price.days }} Days
                                                        </label>
                                                    </div>
                                                    <label class="price text-center block" :for="package.id+'_'+price.id">$@{{ price.price}}</label>
                                                </div>
                                            </div>
                                    </div>
                                </div>
                            </div>
                    </div>
                </div>{{-- end packege selection --}}

                <input type="hidden" name="selected" :value="JSON.stringify(selected)">
                 <div class="col-md-5">
                    <div class="">
                        <h1>Choose Dates</h1>
                        <div class="input-group date form-group datepicker-div">
                            <div  id="datepicker"> </div>
                            <span class="input-group-addon">
                                <i class="glyphicon glyphicon-calendar"></i>
                                <span class="dates-list"></span>
                            </span>
                        </div>
                    </div>  <!-- Calender -->

                    <div class="col-md-12">
                        <div class="row">
                            <div class="col-md-3 text-center">
                                <button class="btn btn-success btn-prev" type="button" @click="changeActiveDate('prev')">Prev</button>
                            </div>
                            <div class="col-md-6">
                                <div class="dates dateselected" id="active-date">@{{ activeDate() }}</div>
                            </div>
                            <div class="col-md-3 text-center">
                                <button class="btn btn-success btn-next" type="button" @click="changeActiveDate('next')">Next</button>
                            </div>
                        </div>
                    </div> <!-- Next button -->

                    <div class="relative">
                        <div  :class="{'overlay-block' : selected.dates.length == 0}"></div>

                        <div class="selectpackages">
                            <div class="noofdays">
                                Default Tiffin
                            </div>
                            <div class="row defaultpackages">

                                    <div class="col-md-12  mt-20" v-for="(dish , d) in dishes" :key="d">
                                        <p class="text-bold"><b>@{{ dish.title }}</b></p>


                                            <table class="tablecss" v-if="dish.is_options">
                                                <tr>
                                                    <th class="text-center" v-for="(option, o) in dish.options" :key="o"> @{{ option.title }}</th>
                                                </tr>
                                                    <tr class="" v-for="j in (dish.options[0].products.length)" :key="j">
                                                        <td v-for="i in (dish.options.length)" :key="i">
                                                                <div class="form-check text-left" >
                                                                    <input
                                                                        class="form-check-input"
                                                                        type="radio"
                                                                        @change="handleProduct(dish.options[i-1].products[j-1])"
                                                                        :name="'default'+ dish.options[i-1].id"
                                                                        :id="'id_'+dish.options[i-1].id+'_'+dish.options[i-1].products[j-1].id"
                                                                    >
                                                                    <label  :for="'id_'+dish.options[i-1].id+'_'+dish.options[i-1].products[j-1].id"
                                                                            class="form-check-label"
                                                                            v-if="dish.options[i-1] !== undefined && dish.options[i-1].products[j-1] !== undefined">
                                                                        @{{  dish.options[i-1].products[j-1].product.name }}
                                                                    </label>
                                                                </div>
                                                        </td>
                                                    </tr>

                                            </table>


                                            <div  v-else>
                                                <template v-if="dish.options[0] !== undefined">
                                                        <div class="form-check text-left" v-for="(product, pr) in dish.options[0].products" :key="pr">
                                                            <input class="form-check-input" @change="handleProduct(product)" type="radio" :name="'default_'+dish.id" :id="'ida_'+product.id+'_'+product.product.id">
                                                            <label class="form-check-label" :for="'ida_'+product.id+'_'+product.product.id">
                                                                    @{{ product.product.name }}
                                                            </label>
                                                        </div>
                                                </template>
                                            </div>

                                    </div>

                                <div class="col-md-12">
                                    <p><b>Salad and Pickle are complimentarly included in the packages</b></p>
                                </div>
                            </div>
                        </div> <!-- product -->

                        <div class="selectpackages pb-0">
                            <div class="noofdays px-2 mb-0 active" data-toggle="collapse" href="#collapseExample" role="button" aria-expanded="true" aria-controls="collapseExample">
                                Add ons <span class="pull-right"><i class="fa fa-chevron-down"></i></span>
                            </div>
                            <div class="row defaultpackages collapse  show" id="collapseExample">
                                <div class="col-md-12">
                                    <div class="row">
                                        <div class="col-md-6">

                                        </div>
                                        <div class="col-md-4">

                                        </div>
                                        <div class="col-md-2">
                                            <p class="text-center"><b>Total</b></p>
                                        </div>
                                    </div>

                                    <div class="borderlinebottom" v-for="(addon , ad) in serialised_addons" :key="ad">
                                            <p><b>@{{ addon.category }}-</b></p>
                                                <div class="row sabji1" v-for="(addon_product , ap) in addon.products" :key="ap">
                                                    <div class="col-md-6">
                                                        <div class="form-check">
                                                            {{-- <input type="checkbox" class="form-check-input" id="sabji1" checked> --}}
                                                            <label class="form-check-label" for="sabji1">@{{ addon_product.product }}</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="input-group mb-3">
                                                            <div class="input-group-prepend">
                                                                <button type="button"  class="input-group-text p59" @click="handleAddonQty( ad, ap, 'dcr')">-</button>
                                                            </div>
                                                            <input  type="text"
                                                                    class="form-control addon-field"
                                                                    readonly
                                                                    min="0"
                                                                    value="0"
                                                                    style="background: #fff;"
                                                                    v-model="addon_product.qty"
                                                            >
                                                            <div class="input-group-append">
                                                                <button type="button"  class="input-group-text" @click="handleAddonQty( ad, ap, 'inc')">+</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <p class="text-center"><span >$@{{ addon_product.total }}</span> </p>
                                                    </div>
                                                </div>
                                    </div>

                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="selectpackages pt-3">
                        <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <p><b>Total</b></p>
                                    </div>
                                    <div class="col-md-6">
                                        <p class="text-right" id="addon-total">$@{{ serialised_addons.sub_total ?? 0.00 }}</p>
                                    </div>
                                    <div class="col-md-12">
                                        <button type="button" class="btn btn-success btn-block add-to-cart-btn" @click="addtocart()">
                                            <div v-if="is_loading">
                                                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                                <span class="sr-only">Loading...</span>
                                            </div>
                                                <span>
                                                    Add to Cart
                                                </span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                    </div>

                 </div>{{-- end middle --}}


                 <div class="col-md-3">
                     <div class="sticky-pos">
                        <div class="mt-6">
                            <div class="selectpackages">
                                <div class="noofdays">
                                    Selected Dates
                                </div>
                                <div class="selecteddates" >
                                    <div class="date-item" v-for="(dates, dt) in selected.dates" :key="dt" :class="{'active' : dates.is_active, 'done' : dates.addons.length > 0}">
                                        @{{ dates.date }}
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="">
                            <div class="selectpackages plr-20 pb-0">
                                <div class="noofdays">
                                    Your Cart
                                </div>
                                <div class="chartsection">
                                    <table class="package-amount-table">
                                        <tr>
                                            <th>Pckage</th>
                                        </tr>
                                        <tr v-if="selected.package != null ">
                                            <td>@{{ selected.package.days   }} days</td>
                                            <td align="right">$@{{ parseFloat(selected.package.price).toFixed(2)   }}</td>
                                        </tr>
                                    </table>
                                    <hr>
                                    <table>
                                        <tr>
                                            <th>Addon</th>
                                        </tr>

                                        <template v-for="(dates, d) in selected.dates" >
                                            <tr v-if="dates.addons.length > 0">
                                                <td>@{{ dates.date }}</td>
                                                <td align="right">$@{{ calculateSubTotal(dates.addons) }}</td>
                                            </tr>
                                        </template>
                                    </table>
                                </div>

                                <table class="mt-20">
                                    <tr class="totalcss">
                                        <td class="text-left pl-20">Total</td>
                                        <td class="text-right pr-20 total-amount">$@{{ calculateGrandTotal() }}</td>
                                    </tr>
                                </table>
                            </div>
                            <div class="">
                                <button type="submit" class="btn btn-success btn-block">Add To Cart</button>
                            </div>
                        </div>
                     </div>


                 </div>
            </form>
        </div>
    </section>

@endsection

@push('js')
    <script src="//code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
    <script src="//cdn.rawgit.com/dubrox/Multiple-Dates-Picker-for-jQuery-UI/master/jquery-ui.multidatespicker.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/vue@2/dist/vue.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/lodash@4.17.21/lodash.min.js"></script>
    {{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.21.4/axios.min.js" ></script> --}}

    <script>
        var app = new Vue({
            el: '#app',
            data: {
                packages: JSON.parse('<?= json_encode($packages) ?>'),
                addons: JSON.parse(`<?= json_encode($addons) ?>`),
                serialised_addons:[],
                dishes: null,
                date_picker:null,
                is_loading:false,
                selected:{
                    package: null,
                    package_id:1,
                    dates: [],
                    range:7,
                }
            },

            async mounted() {
                this.dishes = this.packages[0].default;
                await this.initAll()
                this.initDatePicker()
                this.serializeAddon()
            },

            methods: {
                initAll(){
                    this.selected.range = this.packages[0].range;
                    this.selected.package = this.packages[0].package_price[0];
                    this.selected.package_id = this.packages[0].package_price[0].id;

                },

                initDatePicker(){
                    var vm = this
                    $('#datepicker').multiDatesPicker({
                        minDate: 0,
                        maxPicks: vm.selected.range,
                        pickableRange: vm.selected.package.days,
                        adjustRangeToDisabled: true,
                        changeMonth: true,
                        changeYear: false,
                        dateFormat: "dd-mm-yy",
                        onSelect:(dateText) => this.selectedDates(dateText),
                    });
                },

                serializeAddon(){
                    this.serialised_addons = [];
                    this.addons.forEach((element, ind) => {
                        this.serialised_addons.push({
                            id : element.id,
                            category_id : element.category.id,
                            category: element.category.name,
                            sub_total:0,
                            products:[],

                        });

                        element.addons.forEach(addon => {
                            this.serialised_addons[ind].products.push({
                                qty: 0,
                                total:0,
                                price : addon.product.special_price > 0 ? addon.product.special_price : addon.product.price,
                                product : addon.product.name,
                                product_id: addon.product_id,
                            });
                        });
                    });
                },

                // package Changed
                packageChanged(packages, range){
                    $('#datepicker').multiDatesPicker('destroy');
                    this.selected.package = packages;
                    this.selected.package_id = packages.id;
                    this.selected.range = range;
                    this.selected.dates = [];
                    this.initDatePicker();
                },

                // dateSelected
                selectedDates(dateText){
                    var date_item = {
                        addons: [],
                        date  : dateText,
                        items : [],
                        is_active : false
                    };

                    var check = _.find(this.selected.dates, function(o) {
                            return o.date == dateText;
                    })

                    if(undefined != check){
                        this.selected.dates = $.grep(this.selected.dates, function(value) {
                            return value != check;
                        });
                    }else{
                        this.selected.dates.push(date_item);
                        this.selected.dates[0].is_active = true;
                    }
                },

                //Active date
                activeDate () {
                    var active = _.find(this.selected.dates, function(o) {
                            return o.is_active == true;
                    })
                    return (undefined == active) ? '' : active.date
                },

                // change active date
                changeActiveDate(type){
                    let active_index = _.findIndex(this.selected.dates, ['is_active', true]);

                    if(type == 'next'){

                        if(this.selected.dates[active_index + 1 ] !== undefined){
                            this.selected.dates[active_index].is_active = false;
                            this.selected.dates[active_index + 1 ].is_active = true;
                        }
                    }else{
                        if(this.selected.dates[active_index - 1 ] !== undefined){
                            this.selected.dates[active_index].is_active = false;
                            this.selected.dates[active_index - 1 ].is_active = true;
                        }
                    }
                },

                // handle the product
                handleProduct(product){
                    let active_index = _.findIndex(this.selected.dates, ['is_active', true]);
                    let is_product_exist = _.findIndex(this.selected.dates[active_index].items, ['option_id', product.package_default_options_id]);

                    if(active_index > -1){
                        if(is_product_exist <= -1){
                            this.selected.dates[active_index].items.push({
                                id : product.id,
                                product_id : product.product_id,
                                option_id : product.package_default_options_id
                            });
                        }else{
                            this.selected.dates[active_index].items[is_product_exist].id = product.id;
                            this.selected.dates[active_index].items[is_product_exist].product_id =  product.product_id;
                            this.selected.dates[active_index].items[is_product_exist].option_id = product.package_default_options_id;
                        }
                    }
                },

                // handle qty
                handleAddonQty(addon, product, type){
                    if(type == 'inc'){
                        this.serialised_addons[addon].products[product].qty ++;
                    }else{
                        if(this.serialised_addons[addon].products[product].qty > 0){
                            this.serialised_addons[addon].products[product].qty --;
                        }
                    }
                    this.serialised_addons[addon].products[product].total = parseFloat(this.serialised_addons[addon].products[product].price) * parseFloat(this.serialised_addons[addon].products[product].qty)

                    // subtotal_of addon
                    this.serialised_addons.sub_total = 0;
                    this.serialised_addons.forEach(addon => {
                        addon.products.forEach(product => {
                            this.serialised_addons.sub_total += parseFloat(product.total)
                        });
                    });
                },

                // add to cart
                addtocart(){
                    if(this.selected.dates.length > 0){
                        this.is_loading = true;
                        let active_index = _.findIndex(this.selected.dates, ['is_active', true]);
                        this.selected.dates[active_index].addons = this.serialised_addons;
                        this.changeActiveDate('next');
                        this.serializeAddon();
                        this.is_loading = false;
                    }else{
                    }
                },

                // addon subtotal
                calculateSubTotal(addons){
                    let total = 0;
                        addons.forEach(addon => {
                        addon.products.forEach(product => {
                            total += parseFloat(product.total)
                        });
                    });

                    return parseFloat(total).toFixed(2);
                },

                // calculate Grand Total
                calculateGrandTotal(){
                    var total = this.selected.package != null ?  parseFloat(this.selected.package.price) : 0;

                    this.selected.dates.forEach(date => {
                            total += parseFloat(this.calculateSubTotal(date.addons))
                    });

                    return parseFloat(total).toFixed(2);
                }
            },

        })
    </script>

@endpush



@push('css')
    <link rel="stylesheet" type="text/css" href="https://code.jquery.com/ui/1.12.1/themes/pepper-grinder/jquery-ui.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.rawgit.com/dubrox/Multiple-Dates-Picker-for-jQuery-UI/master/jquery-ui.multidatespicker.css">

    <style>
        #datepicker, .ui-datepicker-inline{
            width: 100%
        }
        .date-item {
            border: 1px solid #d4d4d4;
            margin-bottom: 5px;
            padding: 8px;
            border-radius: 5px;
            background: #ececec;
        }

        .date-item.active{
            background: #E3F4E6;
            border: 1px solid #28b93f;
        }

        .date-item.done{
            background: #28b93f;
            border: 1px solid #28b93f;
        }

        .date-item.error{
            border: 1px solid #eb1414;
            background: #e9bcbc;
        }

        .sticky-pos{
            position: sticky;
            top: 0;
        }

        .relative{
            position: relative;
        }

        .overlay-block{
            position: absolute;
            left: 0;
            top: 0;
            background: rgba(0, 0, 0, .25);
            z-index: 2;
            width: 100%;
            height: 100%;

        }
    </style>
@endpush
