export default {
    methods: {

        integer_validation(event, digit) {
            var keycode = event.which;
            if (!(
                    event.shiftKey == false &&
                    (keycode == 46 ||
                        keycode == 8 ||
                        keycode == 37 ||
                        keycode == 39 ||
                        (keycode >= 48 && keycode <= 57))
                ) ||
                event.target.value.length > digit
            ) {
                event.preventDefault();
            }
        },

        alpha_validation(event, digit) {
            let char = String.fromCharCode(event.keyCode); // Get the character
            if (/^[A-Za-z\s]+$/.test(char) && event.target.value.length < digit)
                return true;
            // Match with regex
            else event.preventDefault(); // If not match, don't add to input text
        },

        alphanumeric_validation(event, digit) {
            let char = String.fromCharCode(event.keyCode); // Get the character
            if (
                /^[A-Za-z0-9\s]+$/.test(char) &&
                event.target.value.length < digit
            )
                return true;
            // Match with regex
            else event.preventDefault(); // If not match, don't add to input text
        },

    }
}