<?php

namespace Database\Seeders;

use App\Models\Package;
use App\Models\PackagePricing;
use Illuminate\Database\Seeder;

class PackageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $package = [
            [ 'name' => 'Daily Pickup', 'type' => 'pickup', 'is_active' => 1,
                'price' =>[['package_id' => 1, 'price' => 12, 	'days' => 1,]]
            ],

            [ 'name' => 'Daily Delivery', 'type' => 'delivery', 'is_active' => 1,
                'price' =>[['package_id' => 1, 'price' => 15,     'days' => 1,]]
            ],

            [ 'name' => 'Pickup Weekly', 'type' => 'pickup', 'is_active' => 1,
                'price' => [
                    ['package_id' => 1, 'price' => 50,     'days' => 5,],
                    ['package_id' => 1, 'price' => 60,     'days' => 6,],
                    ['package_id' => 1, 'price' => 70,     'days' => 7,],
                ]
            ],

            [ 'name' => 'Delivery Weekly', 'type' => 'delivery', 'is_active' => 1,
                'price' => [
                    ['package_id' => 1, 'price' => 55,     'days' => 5,],
                    ['package_id' => 1, 'price' => 65,     'days' => 6,],
                    ['package_id' => 1, 'price' => 75,     'days' => 7,],
                ]
            ],

            [ 'name' => 'Pickup BI Weekly', 'type' => 'pickup', 'is_active' => 1,
                'price' => [
                    ['package_id' => 1, 'price' => 95,     'days' => 5,],
                    ['package_id' => 1, 'price' => 114,     'days' => 6,],
                    ['package_id' => 1, 'price' => 130,     'days' => 7,],
                ]
            ],

            [ 'name' => 'Delivery BI Weekly', 'type' => 'delivery', 'is_active' => 1,
                'price' => [
                    ['package_id' => 1, 'price' => 100,     'days' => 5,],
                    ['package_id' => 1, 'price' => 120,     'days' => 6,],
                    ['package_id' => 1, 'price' => 140,     'days' => 7,],
                ]
            ],

            [ 'name' => 'Pickup Monthly', 'type' => 'pickup', 'is_active' => 1,
                'price' => [
                    ['package_id' => 1, 'price' => 140,     'days' => 5,],
                    ['package_id' => 1, 'price' => 150,     'days' => 6,],
                    ['package_id' => 1, 'price' => 160,     'days' => 7,],
                ]
            ],

            [ 'name' => 'Delivery Monthly', 'type' => 'delivery', 'is_active' => 1,
                'price' => [
                    ['package_id' => 1, 'price' => 150,     'days' => 5,],
                    ['package_id' => 1, 'price' => 160,     'days' => 6,],
                    ['package_id' => 1, 'price' => 170,     'days' => 7,],
                ]
            ],
        ];

        foreach ($package as $key => $value) {
            $package_id = Package::create([
                'name' => $value['name'], 'type' => $value['type'], 'is_active' => $value['is_active']
            ]);
            foreach ($value['price'] as $ky => $va) {
                $va['package_id'] = $package_id->id;
                PackagePricing::create($va);
            }
        }

    }
}
