<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterTableProducts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->date('special_from')->nullable()->after('special_price');
            $table->date('special_to')->nullable()->after('special_from');
            $table->boolean('status')->default('1')->comment('1-active 0-inactive')->after('is_veg');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn('special_from');
            $table->dropColumn('special_to');
            $table->dropColumn('status');
        });
    }
}
