<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePackageDefaultProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('package_default_products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('package_default_options_id')->constrained('package_default_options', 'id')->onDelete('cascade');
            $table->foreignId('product_id')->nullable()->constrained('products', 'id')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('package_default_products');
    }
}
