<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrderItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_items', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('type')->comment('addon, dish');
            $table->bigInteger('qty')->default(0);
            $table->double('sub_total')->default(0);
            $table->double('discount_amount')->default(0);
            $table->double('discount_percentage')->default(0);
            $table->double('tax_amount')->default(0);
            $table->double('tax_percentage')->default(0);
            $table->double('grand_total')->default(0);
            $table->foreignId('product_id')->constrained('products', 'id')->onDelete('cascade');
            $table->foreignId('order_id')->constrained('orders', 'id')->onDelete('cascade');
            $table->foreignId('cart_item_id')->nullable()->constrained('cart_items', 'id')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_items');
    }
}
