<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCartPackagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cart_packages', function (Blueprint $table) {
            $table->id();
            $table->double('sub_total')->default(0);
            $table->double('discount_amount')->default(0);
            $table->double('discount_percentage')->default(0);
            $table->double('tax_amount')->default(0);
            $table->double('tax_percentage')->default(0);
            $table->double('grand_total')->default(0);
            $table->foreignId('package_id')->constrained('packages', 'id')->onDelete('cascade');
            $table->foreignId('cart_id')->constrained('carts', 'id')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cart_packages');
    }
}
