<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCartsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('carts', function (Blueprint $table) {
            $table->id();
            $table->string('status')->default('pending');
            $table->string('customer_first_name')->nullable();
            $table->string('customer_last_name')->nullable();
            $table->string('customer_email')->nullable();
            $table->string('shipping_method')->comment('pickup, delivery')->default('pickup');
            $table->text('note')->nullable();
            $table->bigInteger('item_count')->default(0);
            $table->double('sub_total')->default(0);
            $table->double('discount_amount')->default(0);
            $table->double('discount_percentage')->default(0);
            $table->double('tax_amount')->default(0);
            $table->double('tax_percentage')->default(0);
            $table->double('grand_total')->default(0);
            $table->foreignId('user_id')->constrained('users', 'id')->onDelete('cascade');
            $table->foreignId('shop_id')->nullable()->constrained('shops', 'id')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('carts');
    }
}
