<?php

namespace Database\Factories;

use App\Models\Product;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProductFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Product::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $name = $this->faker->sentence(rand(1, 2));
        return [
            'name' => $name,
            'code' => rand(1, 10000),
            'slug' => Str::slug($name),
            'description' => $this->faker->text(100),
            'price' => $this->faker->randomFloat(2),
            'shop_id' => 1,
            'meta_title' => $this->faker->sentence(10),
            'meta_keywords' => $this->faker->sentence(10),
            'meta_description' => $this->faker->sentence(20),
            'is_active' => 1,
            'is_veg' => 1,
        ];
    }
}
