<?php

namespace Database\Factories;

use App\Models\Category;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Factories\Factory;

class CategoryFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Category::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $name = $this->faker->name;
        return [
            'name' => $name,
            'slug' => Str::slug($name),
            'description' =>  $this->faker->text(100),
            'position' => $this->faker->numberBetween(1, 100),
            'meta_title' => $name,
            'meta_keywords' => $name. $this->faker->text(20),
            'meta_description'=> $this->faker->text(10),
        ];
    }
}
