<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;

class Product extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'slug',
        'description',
        'image',
        'price',
        'special_price',
        'special_from',
        'special_to',
        'shop_id',
        'meta_title',
        'meta_keywords',
        'meta_description',
        'is_active',
        'is_veg',
        'status',
    ];

    public function getSpecialFromAttribute($value)
    {
        return (new Carbon($value))->format('Y-m-d');
    }

    public function getSpecialToAttribute($value)
    {
        return (new Carbon($value))->format('Y-m-d');
    }

    public function setSpecialFromAttribute($value)
    {
        return (new Carbon($value))->format('d M, Y');
    }

    public function setSpecialToAttribute($value)
    {
        return (new Carbon($value))->format('d M, Y');
    }


}
