<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    use HasFactory;

    protected $fillable = [ 'name', 'type', 'is_active' ];


    public function package_price()
    {
        return $this->hasMany(PackagePricing::class);
    }

    public function default()
    {
        return $this->hasMany(PackageDefault::class);
    }

    public function addons_category()
    {
        return $this->hasMany(PackageAddon::class);
    }
}
