<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CatalogProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name'              => 'required|max:128',
            'slug'              => 'required|unique:products,slug,'.(request()->route('product')->id??"").',id|max:256',
            'code'              => 'required',
            'shop_id'           => 'required',
            'price'             => 'required',
            'special_price'     => 'required',
            'special_from'      => 'required',
            'special_to'        => 'required',
            'meta_title'        => '',
            'meta_keywords'     => '',
            'meta_description'  => '',
            'image'             => 'nullable|mimes:jpeg,png,jpg',
            'description'       => 'required',
            'is_veg'            => 'required',
            'status'            => 'required',
        ];
    }
}
