<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CatalogCategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name'              => 'required|max:128',
            'slug'              => 'required|unique:categories,slug,'.(request()->route('category')->id??"").',id|max:256',
            'position'          => 'required',
            'parent_id'         => 'required',
            'image'             => 'nullable|mimes:jpeg,png,jpg',
            'meta_title'        => 'nullable',
            'meta_keywords'     => 'nullable',
            'meta_description'  => 'nullable',
            'description'       => 'required',
            'status'            => 'required',
        ];
    }
}
