<?php

namespace App\Http\Repositories;

use App\Models\Category;
use Image;
use Illuminate\Support\Str;

class CatalogCategoryRepository
{

    public function get($request)
    {
        $column = ['id', 'name', 'slug', 'position', 'updated_at', 'id'];
        $searchColumns = ['name', 'slug', 'position', 'updated_at', 'id'];
        $search = $request['search'];
        $order = $request['orderedColumn'];
        $orderBy = $request['orderBy'];

        // Query
        $query = Category::distinct();

        // search
        if ($search != '') {
            $query->where(function ($q) use ($search, $searchColumns) {
                foreach ($searchColumns as $key => $value) {
                    ($key == 0) ? $q->where($value, 'LIKE', '%' . $search . '%') : $q->orWhere($value, 'LIKE', '%' . $search . '%');
                }

            });
        }

        // sorting
        ($order == '') ? $query->orderByDesc('id') : $query->orderBy($order, $orderBy);

        return $query->paginate(isset($request['perPage']) ? $request['perPage'] : 15);
    }

    public function store($request)
    {
        $data = $request->validated();

        $doc=$request->file("image");
        if (!empty($doc)) {
            if(explode("/",$doc->getClientMimeType())[0] == "image"){
                $data["image"]=$this->imageUpload($doc,'category/images/');
            }else{
                $data["image"]=$this->documentUpload($doc,'category/images/');
            }
        }

        $doc=$request->file("icon");
        if (!empty($doc)) {
            if(explode("/",$doc->getClientMimeType())[0] == "image"){
                $data["icon"]=$this->imageUpload($doc,'category/icon/');
            }else{
                $data["icon"]=$this->documentUpload($doc,'category/icon/');
            }
        }
        Category::create($data);
        return true;
    }

    public function update($request,$category)
    {
        $data = $request->validated();
        $doc=$request->file("image");
        if (!empty($doc)) {
            if(explode("/",$doc->getClientMimeType())[0] == "image"){
                $data["image"]=$this->imageUpload($doc,'catalog/category/images/');
            }else{
                $data["image"]=$this->documentUpload($doc,'catalog/category/images/');
            }
        }

        $doc=$request->file("icon");
        if (!empty($doc)) {
            if(explode("/",$doc->getClientMimeType())[0] == "image"){
                $data["icon"]=$this->imageUpload($doc,'catalog/category/icon/');
            }else{
                $data["icon"]=$this->documentUpload($doc,'catalog/category/icon/');
            }
        }

        $category->update($request->validated());
        return true;
    }

    // public function update($request, $additive): Additive
    // {
    //     $additive = Additive::find($additive);
    //     $additive->name = $request['name'];
    //     $additive->save();

    //     return $additive;
    // }

    // public function destroy($additive): bool
    // {
    //     try {
    //         $additive = Additive::find($additive);
    //         $additive->delete();
    //         return true;
    //     } catch (\Throwable $th) {
    //         return false;
    //     }
    // }

    // public function edit($additive): Additive
    // {
    //     $additives =  Additive::find($additive);
    //     $additives->ref = AdditiveInventory::where('additive_id', $additives->id)->first();
    //     return $additives;
    // }

    //Image Upload
    public function imageUpload($image,$folder)
    {
        $path = [];
        $x = 10;
        if (isset($image) && !empty($image)) {
            $imageName = Str::random($length = 10) . time() . '.' . $image->extension();
            $path = $folder . $imageName;
            if (!is_dir(storage_path('app/public/'.$folder))) mkdir(storage_path('app/public/'.$folder), 0777, TRUE);
            $img = Image::make($image->getRealPath());
            $img->save(storage_path('app/public/'.$path), $x);
        }
        return $path;
    }

    // document upload
    public function documentUpload($document,$folder)
    {
        $path = [];
        if (isset($document)) {
            $documentName = Str::random($length = 10) . time() . '.' . $document->extension();
            $path = $folder . $documentName;
            if (!is_dir(storage_path('app/public/'.$folder))) mkdir(storage_path('app/public/'.$folder), 0777, TRUE);
            $document->move(storage_path('app/public/property/documents'), $documentName);
        }
        return $path;
    }

    public function dropdown_categories()
    {
        return Category::where("status",1)->select("id as value","name as label")->get();
    }

}
