<?php

namespace  App\Http\Repositories;

use App\Models\Cart;
use App\Models\Package;
use App\Models\Product;
use App\Models\PackageAddon;
use App\Models\PackagePricing;
use Illuminate\Support\Facades\Session;

class CartRepository{

    public function addToCard($data)
    {
        $package = PackagePricing::find($data->package_id);
        $this->createCart($data, $package);
    }


    public function createCart($data = null, $package)
    {
        // price calculation
        $base_price = $package->price;
        foreach ($data->dates as  $dates) {
            foreach ($dates->addons as  $addon) {
                foreach ($addon->products as  $product) {
                    $product_data = Product::select('price')->find($product->product_id);
                    // TODO:Special Price Check
                    $base_price += $product_data->price * $product->qty;
                }
            }
        }

        Session::put('total', $base_price);
    }
}
