<?php

namespace App\Http\Controllers;

use App\Http\Repositories\CartRepository;
use App\Models\Package;
use Illuminate\Http\Request;
use App\Models\PackageDefault;
use App\Models\PackageAddonCategory;

class PackageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $packages = Package::with(['package_price', 'default.options.products.product'])->where('is_active', 1)->get();
        $tiffin_items = PackageDefault::with(['options.products.product'])->get();
        $addons = PackageAddonCategory::with(['category', 'addons.product'])->get();
        return view('shop.package.index', compact('packages', 'tiffin_items', 'addons'));
    }

    public function package()
    {
        $packages = Package::with(['package_price', 'default.options.products.product'])->where('is_active', 1)->get();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, CartRepository $repository)
    {
        $repository->addToCard(json_decode($request->selected));
        return redirect()->route('checkout.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Package  $package
     * @return \Illuminate\Http\Response
     */
    public function show(Package $package)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Package  $package
     * @return \Illuminate\Http\Response
     */
    public function edit(Package $package)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Package  $package
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Package $package)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Package  $package
     * @return \Illuminate\Http\Response
     */
    public function destroy(Package $package)
    {
        //
    }
}
