<?php

namespace App\Http\Controllers\Admin;

use Inertia\Inertia;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Repositories\CatalogProductRepository;
use App\Http\Requests\CatalogProductRequest;
use App\Models\Product;

class CatalogProductController extends Controller
{
    public function index(Request $request, CatalogProductRepository $repository)
    {
        $products = $repository->get($request);
        return Inertia::render('Catalog/Product/List', compact('products'));
    }

    public function create(CatalogProductRepository $repository): \Inertia\Response
    {
        $dropdown_shops = $repository->dropdown_shops();
        return Inertia::render('Catalog/Product/Create',compact('dropdown_shops'));
    }

    public function store(CatalogProductRequest $request, CatalogProductRepository $repository): \Illuminate\Http\RedirectResponse
    {
        $repository->store($request);
        return redirect(route('admin.catalog.product.index'))->with('success', 'Product added successfully!');
    }

    public function show(Product $product): \Inertia\Response
    {
        return Inertia::render('Catalog/Product/Show', compact('product'));
    }

    public function edit(Product $product,CatalogProductRepository $repository): \Inertia\Response
    {
        $dropdown_shops = $repository->dropdown_shops();
        return Inertia::render('Catalog/Product/Edit', compact('product','dropdown_shops'));
    }

    public function update(CatalogProductRequest $request,CatalogProductRepository $repository, Product $product): \Illuminate\Http\RedirectResponse
    {
        $repository->update($request,$product);
        return redirect(route('admin.catalog.product.index'))->with('success', 'Product updated successfully!');
    }

}
