<?php

namespace App\Http\Controllers\Admin;

use Inertia\Inertia;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Repositories\CatalogCategoryRepository;
use App\Http\Requests\CatalogCategoryRequest;
use App\Models\Category;

class CatalogCategoryController extends Controller
{
    public function index(Request $request, CatalogCategoryRepository $repository)
    {
        $categories = $repository->get($request);
        return Inertia::render('Catalog/Category/List', compact('categories'));
    }

    public function create(CatalogCategoryRepository $repository): \Inertia\Response
    {
        $dropdown_categories = $repository->dropdown_categories();
        return Inertia::render('Catalog/Category/Create',compact('dropdown_categories'));
    }

    public function store(CatalogCategoryRequest $request, CatalogCategoryRepository $repository): \Illuminate\Http\RedirectResponse
    {
        $repository->store($request);
        return redirect(route('admin.catalog.category.index'))->with('success', 'Category added successfully!');
    }

    public function show(Category $category): \Inertia\Response
    {
        return Inertia::render('Catalog/Category/Show', compact('category'));
    }

    public function edit(Category $category,CatalogCategoryRepository $repository): \Inertia\Response
    {
        $dropdown_categories = $repository->dropdown_categories();
        return Inertia::render('Catalog/Category/Edit', compact('category','dropdown_categories'));
    }

    public function update(CatalogCategoryRequest $request,CatalogCategoryRepository $repository, Category $category): \Illuminate\Http\RedirectResponse
    {
        $repository->update($request,$category);
        return redirect(route('admin.catalog.category.index'))->with('success', 'Category updated successfully!');
    }

    // public function destroy(AfterProduction $qualityCheck): \Illuminate\Http\RedirectResponse
    // {
    //     return redirect()->route('admin.after-production.index')->with('success', 'After Production has been Deleted successfully');
    // }
}
