<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Console\GeneratorCommand;
use Symfony\Component\Console\Input\InputArgument;

class RepositoryMakeCommand extends GeneratorCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    // protected $signature = 'make:repository {repository}';
    protected $name = 'make:repository';
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create new repository';

    /**
     * The type of class being generated.
     *
     * @var string
     */
    protected $type = 'Repository';



    /**
     * Replace the class name for the given stub.
     *
     * @param  string  $stub
     * @param  string  $name
     * @return string
     */
    protected function replaceClass($stub, $name)
    {
        $stub = parent::replaceClass($stub, $name);

        return str_replace('DummyRepository', $this->argument('name'), $stub);

    }

    /**
     * Replace the class name for the given stub.
     *
     * @param  string  $stub
     * @param  string  $name
     * @return string
     */
    protected function buildClass($name)
    {
        // $stub = parent::replaceModel($stub, $name);
        $stub = $this->files->get($this->getStub());
        return str_replace(
            ['DummyRepository', 'DummyModel', 'DummyVariable'],
            [$this->argument('name'), $this->replaceModel(), $this->replaceVariable()],
            $stub
        );
    }


    public function replaceModel()
    {
        return ucwords(str_replace('Repository', '', $this->argument('name')));
    }

    public function replaceVariable()
    {
        return lcfirst(str_replace('Repository', '', $this->argument('name')));
    }



    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub()
    {
        return  app_path() . '/Console/Commands/Stubs/make-repository.stub';
    }

    /**
     * Get the default namespace for the class.
     *
     * @param  string  $rootNamespace
     * @return string
     */
    protected function getDefaultNamespace($rootNamespace)
    {
        return $rootNamespace . '\Http\Repositories';
    }

    /**
     * Get the console command arguments.
     *
     * @return array
     */
    protected function getArguments()
    {
        return [
            ['name', InputArgument::REQUIRED, 'The name of the repository.' ],
        ];
    }
}
