<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Str;

class ModuleMakeCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:module {module}';


    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create Module';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->createController();
        $this->createRequest();
        $this->createRepository();
        $this->createModel();
        $this->createMigration();
    }

    /**
     * Create a controller for the model.
     *
     * @return void
     */
    protected function createController()
    {
        $controller = Str::studly(class_basename($this->argument('module')));

        $this->call('make:controller', array_filter([
            'name'  => "{$controller}Controller",
        ]));
    }

    protected function createMigration()
    {
        $table = Str::snake(Str::pluralStudly(class_basename($this->argument('module'))));

        $this->call('make:migration', [
            'name' => "create_{$table}_table",
            '--create' => $table,
        ]);
    }

    protected function createRequest()
    {
        $this->call('make:request', array_filter([
            'name'  => $this->argument('module')."Request",
        ]));
    }

    protected function createRepository()
    {
        $this->call('make:repository', array_filter([
            'name'  => $this->argument('module')."Repository",
        ]));
    }

    protected function createModel()
    {
        $this->call('make:model', array_filter([
            'name'  => $this->argument('module'),
        ]));
    }

}
